// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     components/dom_distiller/content/common/distiller_page_notifier_service.mojom
//

package org.chromium.mojom.dom_distiller;

class DistillerPageNotifierService_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<DistillerPageNotifierService, DistillerPageNotifierService.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<DistillerPageNotifierService, DistillerPageNotifierService.Proxy>() {
    
        public String getName() {
            return "dom_distiller::DistillerPageNotifierService";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, DistillerPageNotifierService impl) {
            return new Stub(core, impl);
        }
    
        public DistillerPageNotifierService[] buildArray(int size) {
          return new DistillerPageNotifierService[size];
        }
    };

    private static final int NOTIFY_IS_DISTILLER_PAGE_ORDINAL = 0;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements DistillerPageNotifierService.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void notifyIsDistillerPage() {
            DistillerPageNotifierServiceNotifyIsDistillerPageParams _message = new DistillerPageNotifierServiceNotifyIsDistillerPageParams();
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(NOTIFY_IS_DISTILLER_PAGE_ORDINAL)));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<DistillerPageNotifierService> {

        Stub(org.chromium.mojo.system.Core core, DistillerPageNotifierService impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                DistillerPageNotifierService_Internal.MANAGER, messageWithHeader);
                    case NOTIFY_IS_DISTILLER_PAGE_ORDINAL: {
                        DistillerPageNotifierServiceNotifyIsDistillerPageParams.deserialize(messageWithHeader.getPayload());
                        getImpl().notifyIsDistillerPage();
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), DistillerPageNotifierService_Internal.MANAGER, messageWithHeader, receiver);
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class DistillerPageNotifierServiceNotifyIsDistillerPageParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 8;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(8, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        private DistillerPageNotifierServiceNotifyIsDistillerPageParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public DistillerPageNotifierServiceNotifyIsDistillerPageParams() {
            this(0);
        }
    
        public static DistillerPageNotifierServiceNotifyIsDistillerPageParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static DistillerPageNotifierServiceNotifyIsDistillerPageParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            DistillerPageNotifierServiceNotifyIsDistillerPageParams result = new DistillerPageNotifierServiceNotifyIsDistillerPageParams(mainDataHeader.elementsOrVersion);
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            return result;
        }
    }

}

